package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnenoteSection;
import odata.msgraph.client.beta.entity.request.OnenotePageRequest;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;

public class OnenoteSectionCollectionRequest extends CollectionPageEntityRequest<OnenoteSection, OnenoteSectionRequest>{

    protected ContextPath contextPath;

    public OnenoteSectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OnenoteSection.class, cp -> new OnenoteSectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OnenotePageRequest pages(String id) {
        return new OnenotePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenotePageCollectionRequest pages() {
        return new OnenotePageCollectionRequest(contextPath.addSegment("pages"), Optional.empty());
    }

}
