package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnPremisesPublishingProfile;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesPublishingProfileRequest;
import odata.msgraph.client.beta.entity.request.PublishedResourceRequest;

public class OnPremisesPublishingProfileCollectionRequest extends CollectionPageEntityRequest<OnPremisesPublishingProfile, OnPremisesPublishingProfileRequest>{

    protected ContextPath contextPath;

    public OnPremisesPublishingProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OnPremisesPublishingProfile.class, cp -> new OnPremisesPublishingProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(contextPath.addSegment("agentGroups"), Optional.empty());
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(contextPath.addSegment("agents"), Optional.empty());
    }

    public ConnectorGroupRequest connectorGroups(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorGroupCollectionRequest connectorGroups() {
        return new ConnectorGroupCollectionRequest(contextPath.addSegment("connectorGroups"), Optional.empty());
    }

    public ConnectorRequest connectors(String id) {
        return new ConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorCollectionRequest connectors() {
        return new ConnectorCollectionRequest(contextPath.addSegment("connectors"), Optional.empty());
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(contextPath.addSegment("publishedResources"), Optional.empty());
    }

}
