package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnPremisesAgentGroup;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentRequest;
import odata.msgraph.client.beta.entity.request.PublishedResourceRequest;

public class OnPremisesAgentGroupCollectionRequest extends CollectionPageEntityRequest<OnPremisesAgentGroup, OnPremisesAgentGroupRequest>{

    protected ContextPath contextPath;

    public OnPremisesAgentGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OnPremisesAgentGroup.class, cp -> new OnPremisesAgentGroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(contextPath.addSegment("agents"), Optional.empty());
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(contextPath.addSegment("publishedResources"), Optional.empty());
    }

}
