package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CopyNotebookModel;
import odata.msgraph.client.beta.complex.RecentNotebook;
import odata.msgraph.client.beta.entity.Notebook;
import odata.msgraph.client.beta.entity.request.NotebookRequest;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;
import odata.msgraph.client.beta.entity.request.SectionGroupRequest;

public class NotebookCollectionRequest extends CollectionPageEntityRequest<Notebook, NotebookRequest>{

    protected ContextPath contextPath;

    public NotebookCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Notebook.class, cp -> new NotebookRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(contextPath.addSegment("sectionGroups"), Optional.empty());
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(contextPath.addSegment("sections"), Optional.empty());
    }

    @Action(name = "getNotebookFromWebUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CopyNotebookModel> getNotebookFromWebUrl(String webUrl) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("webUrl", "Edm.String", Checks.checkIsAscii(webUrl))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CopyNotebookModel>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getNotebookFromWebUrl"), CopyNotebookModel.class, _parameters);
    }

    @Function(name = "getRecentNotebooks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RecentNotebook> getRecentNotebooks(Boolean includePersonalNotebooks) {
        Preconditions.checkNotNull(includePersonalNotebooks, "includePersonalNotebooks cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("includePersonalNotebooks", "Edm.Boolean", includePersonalNotebooks)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRecentNotebooks"), RecentNotebook.class, _parameters);
    }

}
