package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobilityManagementPolicy;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.MobilityManagementPolicyRequest;

public class MobilityManagementPolicyCollectionRequest extends CollectionPageEntityRequest<MobilityManagementPolicy, MobilityManagementPolicyRequest>{

    protected ContextPath contextPath;

    public MobilityManagementPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MobilityManagementPolicy.class, cp -> new MobilityManagementPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupRequest includedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("includedGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest includedGroups() {
        return new GroupCollectionRequest(contextPath.addSegment("includedGroups"), Optional.empty());
    }

}
