package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MicrosoftTunnelSite;
import odata.msgraph.client.beta.entity.request.MicrosoftTunnelServerRequest;
import odata.msgraph.client.beta.entity.request.MicrosoftTunnelSiteRequest;

public class MicrosoftTunnelSiteCollectionRequest extends CollectionPageEntityRequest<MicrosoftTunnelSite, MicrosoftTunnelSiteRequest>{

    protected ContextPath contextPath;

    public MicrosoftTunnelSiteCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MicrosoftTunnelSite.class, cp -> new MicrosoftTunnelSiteRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MicrosoftTunnelServerRequest microsoftTunnelServers(String id) {
        return new MicrosoftTunnelServerRequest(contextPath.addSegment("microsoftTunnelServers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftTunnelServerCollectionRequest microsoftTunnelServers() {
        return new MicrosoftTunnelServerCollectionRequest(contextPath.addSegment("microsoftTunnelServers"), Optional.empty());
    }

}
