package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MessageRecipient;
import odata.msgraph.client.beta.entity.request.MessageEventRequest;
import odata.msgraph.client.beta.entity.request.MessageRecipientRequest;

public class MessageRecipientCollectionRequest extends CollectionPageEntityRequest<MessageRecipient, MessageRecipientRequest>{

    protected ContextPath contextPath;

    public MessageRecipientCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MessageRecipient.class, cp -> new MessageRecipientRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MessageEventRequest events(String id) {
        return new MessageEventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageEventCollectionRequest events() {
        return new MessageEventCollectionRequest(contextPath.addSegment("events"), Optional.empty());
    }

}
