package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MeetingAttendanceReport;
import odata.msgraph.client.beta.entity.request.AttendanceRecordRequest;
import odata.msgraph.client.beta.entity.request.MeetingAttendanceReportRequest;

public class MeetingAttendanceReportCollectionRequest extends CollectionPageEntityRequest<MeetingAttendanceReport, MeetingAttendanceReportRequest>{

    protected ContextPath contextPath;

    public MeetingAttendanceReportCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MeetingAttendanceReport.class, cp -> new MeetingAttendanceReportRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AttendanceRecordRequest attendanceRecords(String id) {
        return new AttendanceRecordRequest(contextPath.addSegment("attendanceRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AttendanceRecordCollectionRequest attendanceRecords() {
        return new AttendanceRecordCollectionRequest(contextPath.addSegment("attendanceRecords"), Optional.empty());
    }

}
