package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedDeviceMobileAppConfiguration;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationDeviceStatusRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationUserStatusRequest;

public class ManagedDeviceMobileAppConfigurationCollectionRequest extends CollectionPageEntityRequest<ManagedDeviceMobileAppConfiguration, ManagedDeviceMobileAppConfigurationRequest>{

    protected ContextPath contextPath;

    public ManagedDeviceMobileAppConfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagedDeviceMobileAppConfiguration.class, cp -> new ManagedDeviceMobileAppConfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagedDeviceMobileAppConfigurationAssignmentRequest assignments(String id) {
        return new ManagedDeviceMobileAppConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest assignments() {
        return new ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationUserStatusRequest userStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest userStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(contextPath.addSegment("userStatuses"), Optional.empty());
    }

}
