package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MailFolder;
import odata.msgraph.client.beta.entity.request.MailFolderRequest;
import odata.msgraph.client.beta.entity.request.MessageRequest;
import odata.msgraph.client.beta.entity.request.MessageRuleRequest;
import odata.msgraph.client.beta.entity.request.MultiValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.SingleValueLegacyExtendedPropertyRequest;
import odata.msgraph.client.beta.entity.request.UserConfigurationRequest;

public class MailFolderCollectionRequest extends CollectionPageEntityRequest<MailFolder, MailFolderRequest>{

    protected ContextPath contextPath;

    public MailFolderCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MailFolder.class, cp -> new MailFolderRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MailFolderRequest childFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("childFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MailFolderCollectionRequest childFolders() {
        return new MailFolderCollectionRequest(contextPath.addSegment("childFolders"), Optional.empty());
    }

    public MessageRuleRequest messageRules(String id) {
        return new MessageRuleRequest(contextPath.addSegment("messageRules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageRuleCollectionRequest messageRules() {
        return new MessageRuleCollectionRequest(contextPath.addSegment("messageRules"), Optional.empty());
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(contextPath.addSegment("messages"), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

    public UserConfigurationRequest userConfigurations(String id) {
        return new UserConfigurationRequest(contextPath.addSegment("userConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserConfigurationCollectionRequest userConfigurations() {
        return new UserConfigurationCollectionRequest(contextPath.addSegment("userConfigurations"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailFolder> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), MailFolder.class, _parameters);
    }

}
