package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSSoftwareUpdateAccountSummary;
import odata.msgraph.client.beta.entity.request.MacOSSoftwareUpdateAccountSummaryRequest;
import odata.msgraph.client.beta.entity.request.MacOSSoftwareUpdateCategorySummaryRequest;

public class MacOSSoftwareUpdateAccountSummaryCollectionRequest extends CollectionPageEntityRequest<MacOSSoftwareUpdateAccountSummary, MacOSSoftwareUpdateAccountSummaryRequest>{

    protected ContextPath contextPath;

    public MacOSSoftwareUpdateAccountSummaryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, MacOSSoftwareUpdateAccountSummary.class, cp -> new MacOSSoftwareUpdateAccountSummaryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MacOSSoftwareUpdateCategorySummaryRequest categorySummaries(String id) {
        return new MacOSSoftwareUpdateCategorySummaryRequest(contextPath.addSegment("categorySummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOSSoftwareUpdateCategorySummaryCollectionRequest categorySummaries() {
        return new MacOSSoftwareUpdateCategorySummaryCollectionRequest(contextPath.addSegment("categorySummaries"), Optional.empty());
    }

}
