package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.List;
import odata.msgraph.client.beta.entity.request.ColumnDefinitionRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.entity.request.ListItemRequest;
import odata.msgraph.client.beta.entity.request.ListRequest;
import odata.msgraph.client.beta.entity.request.RichLongRunningOperationRequest;
import odata.msgraph.client.beta.entity.request.SubscriptionRequest;

public class ListCollectionRequest extends CollectionPageEntityRequest<List, ListRequest>{

    protected ContextPath contextPath;

    public ListCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, List.class, cp -> new ListRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"), Optional.empty());
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("columns"), Optional.empty());
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(contextPath.addSegment("contentTypes"), Optional.empty());
    }

    public ListItemRequest items(String id) {
        return new ListItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ListItemCollectionRequest items() {
        return new ListItemCollectionRequest(contextPath.addSegment("items"), Optional.empty());
    }

    public RichLongRunningOperationRequest operations(String id) {
        return new RichLongRunningOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RichLongRunningOperationCollectionRequest operations() {
        return new RichLongRunningOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(contextPath.addSegment("subscriptions"), Optional.empty());
    }

}
