package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Item;
import odata.msgraph.client.beta.entity.request.ItemRequest;
import odata.msgraph.client.beta.entity.request.PictureRequest;

public class ItemCollectionRequest extends CollectionPageEntityRequest<Item, ItemRequest>{

    protected ContextPath contextPath;

    public ItemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Item.class, cp -> new ItemRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"), Optional.empty());
    }

}
