package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.request.ItemActivityRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityStatRequest;

public class ItemActivityStatCollectionRequest extends CollectionPageEntityRequest<ItemActivityStat, ItemActivityStatRequest>{

    protected ContextPath contextPath;

    public ItemActivityStatCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ItemActivityStat.class, cp -> new ItemActivityStatRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ItemActivityRequest activities(String id) {
        return new ItemActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityCollectionRequest activities() {
        return new ItemActivityCollectionRequest(contextPath.addSegment("activities"), Optional.empty());
    }

}
