package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.IosLobAppProvisioningConfiguration;
import odata.msgraph.client.beta.entity.request.IosLobAppProvisioningConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.IosLobAppProvisioningConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationDeviceStatusRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationUserStatusRequest;
import odata.msgraph.client.beta.entity.request.MobileAppProvisioningConfigGroupAssignmentRequest;

public class IosLobAppProvisioningConfigurationCollectionRequest extends CollectionPageEntityRequest<IosLobAppProvisioningConfiguration, IosLobAppProvisioningConfigurationRequest>{

    protected ContextPath contextPath;

    public IosLobAppProvisioningConfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, IosLobAppProvisioningConfiguration.class, cp -> new IosLobAppProvisioningConfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public IosLobAppProvisioningConfigurationAssignmentRequest assignments(String id) {
        return new IosLobAppProvisioningConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IosLobAppProvisioningConfigurationAssignmentCollectionRequest assignments() {
        return new IosLobAppProvisioningConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public MobileAppProvisioningConfigGroupAssignmentRequest groupAssignments(String id) {
        return new MobileAppProvisioningConfigGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppProvisioningConfigGroupAssignmentCollectionRequest groupAssignments() {
        return new MobileAppProvisioningConfigGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationUserStatusRequest userStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest userStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(contextPath.addSegment("userStatuses"), Optional.empty());
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters);
    }

}
