package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationResult;
import odata.msgraph.client.beta.complex.ContentInfo;
import odata.msgraph.client.beta.complex.DowngradeJustification;
import odata.msgraph.client.beta.complex.InformationProtectionAction;
import odata.msgraph.client.beta.complex.InformationProtectionContentLabel;
import odata.msgraph.client.beta.complex.LabelingOptions;
import odata.msgraph.client.beta.entity.InformationProtectionLabel;
import odata.msgraph.client.beta.entity.request.InformationProtectionLabelRequest;

public class InformationProtectionLabelCollectionRequest extends CollectionPageEntityRequest<InformationProtectionLabel, InformationProtectionLabelRequest>{

    protected ContextPath contextPath;

    public InformationProtectionLabelCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, InformationProtectionLabel.class, cp -> new InformationProtectionLabelRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "evaluateApplication")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InformationProtectionAction> evaluateApplication(ContentInfo contentInfo, LabelingOptions labelingOptions) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Preconditions.checkNotNull(labelingOptions, "labelingOptions cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.contentInfo", contentInfo)
            .put("labelingOptions", "microsoft.graph.labelingOptions", labelingOptions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateApplication"), InformationProtectionAction.class, _parameters);
    }

    @Action(name = "evaluateClassificationResults")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InformationProtectionAction> evaluateClassificationResults(ContentInfo contentInfo, List<ClassificationResult> classificationResults) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Preconditions.checkNotNull(classificationResults, "classificationResults cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.contentInfo", contentInfo)
            .put("classificationResults", "Collection(microsoft.graph.classificationResult)", classificationResults)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateClassificationResults"), InformationProtectionAction.class, _parameters);
    }

    @Action(name = "evaluateRemoval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InformationProtectionAction> evaluateRemoval(ContentInfo contentInfo, DowngradeJustification downgradeJustification) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.contentInfo", contentInfo)
            .put("downgradeJustification", "microsoft.graph.downgradeJustification", downgradeJustification)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateRemoval"), InformationProtectionAction.class, _parameters);
    }

    @Action(name = "extractLabel")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InformationProtectionContentLabel> extractLabel(ContentInfo contentInfo) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.contentInfo", contentInfo)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InformationProtectionContentLabel>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.extractLabel"), InformationProtectionContentLabel.class, _parameters);
    }

}
