package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IdentityProvider;
import odata.msgraph.client.beta.entity.request.IdentityProviderRequest;

public class IdentityProviderCollectionRequest extends CollectionPageEntityRequest<IdentityProvider, IdentityProviderRequest>{

    protected ContextPath contextPath;

    public IdentityProviderCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, IdentityProvider.class, cp -> new IdentityProviderRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "availableProviderTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> availableProviderTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.availableProviderTypes"), String.class, _parameters);
    }

}
