package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyUploadedDefinitionFile;
import odata.msgraph.client.beta.entity.request.GroupPolicyOperationRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyUploadedDefinitionFileRequest;

public class GroupPolicyUploadedDefinitionFileCollectionRequest extends CollectionPageEntityRequest<GroupPolicyUploadedDefinitionFile, GroupPolicyUploadedDefinitionFileRequest>{

    protected ContextPath contextPath;

    public GroupPolicyUploadedDefinitionFileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyUploadedDefinitionFile.class, cp -> new GroupPolicyUploadedDefinitionFileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicyOperationRequest groupPolicyOperations(String id) {
        return new GroupPolicyOperationRequest(contextPath.addSegment("groupPolicyOperations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyOperationCollectionRequest groupPolicyOperations() {
        return new GroupPolicyOperationCollectionRequest(contextPath.addSegment("groupPolicyOperations"), Optional.empty());
    }

}
