package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyMigrationReport;
import odata.msgraph.client.beta.entity.GroupPolicyObjectFile;
import odata.msgraph.client.beta.entity.request.GroupPolicyMigrationReportRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicySettingMappingRequest;
import odata.msgraph.client.beta.entity.request.UnsupportedGroupPolicyExtensionRequest;

public class GroupPolicyMigrationReportCollectionRequest extends CollectionPageEntityRequest<GroupPolicyMigrationReport, GroupPolicyMigrationReportRequest>{

    protected ContextPath contextPath;

    public GroupPolicyMigrationReportCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyMigrationReport.class, cp -> new GroupPolicyMigrationReportRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicySettingMappingRequest groupPolicySettingMappings(String id) {
        return new GroupPolicySettingMappingRequest(contextPath.addSegment("groupPolicySettingMappings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicySettingMappingCollectionRequest groupPolicySettingMappings() {
        return new GroupPolicySettingMappingCollectionRequest(contextPath.addSegment("groupPolicySettingMappings"), Optional.empty());
    }

    public UnsupportedGroupPolicyExtensionRequest unsupportedGroupPolicyExtensions(String id) {
        return new UnsupportedGroupPolicyExtensionRequest(contextPath.addSegment("unsupportedGroupPolicyExtensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnsupportedGroupPolicyExtensionCollectionRequest unsupportedGroupPolicyExtensions() {
        return new UnsupportedGroupPolicyExtensionCollectionRequest(contextPath.addSegment("unsupportedGroupPolicyExtensions"), Optional.empty());
    }

    @Action(name = "createMigrationReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createMigrationReport(GroupPolicyObjectFile groupPolicyObjectFile) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyObjectFile", "microsoft.graph.groupPolicyObjectFile", groupPolicyObjectFile)
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createMigrationReport"), String.class, _parameters);
    }

}
