package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionFile;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionFileRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;

public class GroupPolicyDefinitionFileCollectionRequest extends CollectionPageEntityRequest<GroupPolicyDefinitionFile, GroupPolicyDefinitionFileRequest>{

    protected ContextPath contextPath;

    public GroupPolicyDefinitionFileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyDefinitionFile.class, cp -> new GroupPolicyDefinitionFileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(contextPath.addSegment("definitions"), Optional.empty());
    }

}
