package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyConfiguration;
import odata.msgraph.client.beta.entity.request.GroupPolicyConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyConfigurationRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionValueRequest;

public class GroupPolicyConfigurationCollectionRequest extends CollectionPageEntityRequest<GroupPolicyConfiguration, GroupPolicyConfigurationRequest>{

    protected ContextPath contextPath;

    public GroupPolicyConfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyConfiguration.class, cp -> new GroupPolicyConfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicyConfigurationAssignmentRequest assignments(String id) {
        return new GroupPolicyConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyConfigurationAssignmentCollectionRequest assignments() {
        return new GroupPolicyConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public GroupPolicyDefinitionValueRequest definitionValues(String id) {
        return new GroupPolicyDefinitionValueRequest(contextPath.addSegment("definitionValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionValueCollectionRequest definitionValues() {
        return new GroupPolicyDefinitionValueCollectionRequest(contextPath.addSegment("definitionValues"), Optional.empty());
    }

}
