package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyCategory;
import odata.msgraph.client.beta.entity.request.GroupPolicyCategoryRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;

public class GroupPolicyCategoryCollectionRequest extends CollectionPageEntityRequest<GroupPolicyCategory, GroupPolicyCategoryRequest>{

    protected ContextPath contextPath;

    public GroupPolicyCategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupPolicyCategory.class, cp -> new GroupPolicyCategoryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupPolicyCategoryRequest children(String id) {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyCategoryCollectionRequest children() {
        return new GroupPolicyCategoryCollectionRequest(contextPath.addSegment("children"), Optional.empty());
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(contextPath.addSegment("definitions"), Optional.empty());
    }

}
