package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupLifecyclePolicy;
import odata.msgraph.client.beta.entity.request.GroupLifecyclePolicyRequest;

public class GroupLifecyclePolicyCollectionRequest extends CollectionPageEntityRequest<GroupLifecyclePolicy, GroupLifecyclePolicyRequest>{

    protected ContextPath contextPath;

    public GroupLifecyclePolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GroupLifecyclePolicy.class, cp -> new GroupLifecyclePolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "renewGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> renewGroup(String groupId) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renewGroup"), Boolean.class, _parameters);
    }

}
