package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GovernanceRoleAssignment;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;

public class GovernanceRoleAssignmentCollectionRequest extends CollectionPageEntityRequest<GovernanceRoleAssignment, GovernanceRoleAssignmentRequest>{

    protected ContextPath contextPath;

    public GovernanceRoleAssignmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GovernanceRoleAssignment.class, cp -> new GovernanceRoleAssignmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "export")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> export() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.export"), String.class, _parameters);
    }

}
