package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GovernanceResource;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;

public class GovernanceResourceCollectionRequest extends CollectionPageEntityRequest<GovernanceResource, GovernanceResourceRequest>{

    protected ContextPath contextPath;

    public GovernanceResourceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, GovernanceResource.class, cp -> new GovernanceResourceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GovernanceRoleAssignmentRequestRequest roleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("roleAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleAssignmentRequestCollectionRequest roleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(contextPath.addSegment("roleAssignmentRequests"), Optional.empty());
    }

    public GovernanceRoleAssignmentRequest roleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleAssignmentCollectionRequest roleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(contextPath.addSegment("roleAssignments"), Optional.empty());
    }

    public GovernanceRoleDefinitionRequest roleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleDefinitionCollectionRequest roleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(contextPath.addSegment("roleDefinitions"), Optional.empty());
    }

    public GovernanceRoleSettingRequest roleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleSettingCollectionRequest roleSettings() {
        return new GovernanceRoleSettingCollectionRequest(contextPath.addSegment("roleSettings"), Optional.empty());
    }

    @Action(name = "register")
    @JsonIgnore
    public ActionRequestNoReturn register(String externalId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("externalId", "Edm.String", Checks.checkIsAscii(externalId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.register"), _parameters);
    }

}
