package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ExternalConnection;
import odata.msgraph.client.beta.entity.request.ConnectionOperationRequest;
import odata.msgraph.client.beta.entity.request.ExternalConnectionRequest;
import odata.msgraph.client.beta.entity.request.ExternalGroupRequest;
import odata.msgraph.client.beta.entity.request.ExternalItemRequest;

public class ExternalConnectionCollectionRequest extends CollectionPageEntityRequest<ExternalConnection, ExternalConnectionRequest>{

    protected ContextPath contextPath;

    public ExternalConnectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ExternalConnection.class, cp -> new ExternalConnectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExternalGroupRequest groups(String id) {
        return new ExternalGroupRequest(contextPath.addSegment("groups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalGroupCollectionRequest groups() {
        return new ExternalGroupCollectionRequest(contextPath.addSegment("groups"), Optional.empty());
    }

    public ExternalItemRequest items(String id) {
        return new ExternalItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalItemCollectionRequest items() {
        return new ExternalItemCollectionRequest(contextPath.addSegment("items"), Optional.empty());
    }

    public ConnectionOperationRequest operations(String id) {
        return new ConnectionOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectionOperationCollectionRequest operations() {
        return new ConnectionOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

}
