package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Employee;
import odata.msgraph.client.beta.entity.request.EmployeeRequest;
import odata.msgraph.client.beta.entity.request.PictureRequest;

public class EmployeeCollectionRequest extends CollectionPageEntityRequest<Employee, EmployeeRequest>{

    protected ContextPath contextPath;

    public EmployeeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Employee.class, cp -> new EmployeeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"), Optional.empty());
    }

}
