package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationSynchronizationProfile;
import odata.msgraph.client.beta.entity.request.EducationSynchronizationErrorRequest;
import odata.msgraph.client.beta.entity.request.EducationSynchronizationProfileRequest;

public class EducationSynchronizationProfileCollectionRequest extends CollectionPageEntityRequest<EducationSynchronizationProfile, EducationSynchronizationProfileRequest>{

    protected ContextPath contextPath;

    public EducationSynchronizationProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EducationSynchronizationProfile.class, cp -> new EducationSynchronizationProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public EducationSynchronizationErrorRequest errors(String id) {
        return new EducationSynchronizationErrorRequest(contextPath.addSegment("errors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSynchronizationErrorCollectionRequest errors() {
        return new EducationSynchronizationErrorCollectionRequest(contextPath.addSegment("errors"), Optional.empty());
    }

}
