package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationSubmission;
import odata.msgraph.client.beta.entity.request.EducationOutcomeRequest;
import odata.msgraph.client.beta.entity.request.EducationSubmissionRequest;
import odata.msgraph.client.beta.entity.request.EducationSubmissionResourceRequest;

public class EducationSubmissionCollectionRequest extends CollectionPageEntityRequest<EducationSubmission, EducationSubmissionRequest>{

    protected ContextPath contextPath;

    public EducationSubmissionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EducationSubmission.class, cp -> new EducationSubmissionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public EducationOutcomeRequest outcomes(String id) {
        return new EducationOutcomeRequest(contextPath.addSegment("outcomes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationOutcomeCollectionRequest outcomes() {
        return new EducationOutcomeCollectionRequest(contextPath.addSegment("outcomes"), Optional.empty());
    }

    public EducationSubmissionResourceRequest resources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSubmissionResourceCollectionRequest resources() {
        return new EducationSubmissionResourceCollectionRequest(contextPath.addSegment("resources"), Optional.empty());
    }

    public EducationSubmissionResourceRequest submittedResources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("submittedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSubmissionResourceCollectionRequest submittedResources() {
        return new EducationSubmissionResourceCollectionRequest(contextPath.addSegment("submittedResources"), Optional.empty());
    }

}
