package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationClass;
import odata.msgraph.client.beta.entity.request.EducationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EducationCategoryRequest;
import odata.msgraph.client.beta.entity.request.EducationClassRequest;
import odata.msgraph.client.beta.entity.request.EducationSchoolRequest;
import odata.msgraph.client.beta.entity.request.EducationUserRequest;

public class EducationClassCollectionRequest extends CollectionPageEntityRequest<EducationClass, EducationClassRequest>{

    protected ContextPath contextPath;

    public EducationClassCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EducationClass.class, cp -> new EducationClassRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public EducationCategoryRequest assignmentCategories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("assignmentCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationCategoryCollectionRequest assignmentCategories() {
        return new EducationCategoryCollectionRequest(contextPath.addSegment("assignmentCategories"), Optional.empty());
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public EducationUserRequest members(String id) {
        return new EducationUserRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationUserCollectionRequest members() {
        return new EducationUserCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(contextPath.addSegment("schools"), Optional.empty());
    }

    public EducationUserRequest teachers(String id) {
        return new EducationUserRequest(contextPath.addSegment("teachers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationUserCollectionRequest teachers() {
        return new EducationUserCollectionRequest(contextPath.addSegment("teachers"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationClass> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), EducationClass.class, _parameters);
    }

}
