package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationAssignment;
import odata.msgraph.client.beta.entity.request.EducationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.EducationAssignmentResourceRequest;
import odata.msgraph.client.beta.entity.request.EducationCategoryRequest;
import odata.msgraph.client.beta.entity.request.EducationSubmissionRequest;

public class EducationAssignmentCollectionRequest extends CollectionPageEntityRequest<EducationAssignment, EducationAssignmentRequest>{

    protected ContextPath contextPath;

    public EducationAssignmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EducationAssignment.class, cp -> new EducationAssignmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public EducationCategoryRequest categories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationCategoryCollectionRequest categories() {
        return new EducationCategoryCollectionRequest(contextPath.addSegment("categories"), Optional.empty());
    }

    public EducationAssignmentResourceRequest resources(String id) {
        return new EducationAssignmentResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationAssignmentResourceCollectionRequest resources() {
        return new EducationAssignmentResourceCollectionRequest(contextPath.addSegment("resources"), Optional.empty());
    }

    public EducationSubmissionRequest submissions(String id) {
        return new EducationSubmissionRequest(contextPath.addSegment("submissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSubmissionCollectionRequest submissions() {
        return new EducationSubmissionCollectionRequest(contextPath.addSegment("submissions"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationAssignment> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), EducationAssignment.class, _parameters);
    }

}
