package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DriveItem;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.DriveItemVersionRequest;
import odata.msgraph.client.beta.entity.request.ItemActivityOLDRequest;
import odata.msgraph.client.beta.entity.request.PermissionRequest;
import odata.msgraph.client.beta.entity.request.SubscriptionRequest;
import odata.msgraph.client.beta.entity.request.ThumbnailSetRequest;

public class DriveItemCollectionRequest extends CollectionPageEntityRequest<DriveItem, DriveItemRequest>{

    protected ContextPath contextPath;

    public DriveItemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DriveItem.class, cp -> new DriveItemRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(contextPath.addSegment("activities"), Optional.empty());
    }

    public DriveItemRequest children(String id) {
        return new DriveItemRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest children() {
        return new DriveItemCollectionRequest(contextPath.addSegment("children"), Optional.empty());
    }

    public PermissionRequest permissions(String id) {
        return new PermissionRequest(contextPath.addSegment("permissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionCollectionRequest permissions() {
        return new PermissionCollectionRequest(contextPath.addSegment("permissions"), Optional.empty());
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(contextPath.addSegment("subscriptions"), Optional.empty());
    }

    public ThumbnailSetRequest thumbnails(String id) {
        return new ThumbnailSetRequest(contextPath.addSegment("thumbnails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ThumbnailSetCollectionRequest thumbnails() {
        return new ThumbnailSetCollectionRequest(contextPath.addSegment("thumbnails"), Optional.empty());
    }

    public DriveItemVersionRequest versions(String id) {
        return new DriveItemVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemVersionCollectionRequest versions() {
        return new DriveItemVersionCollectionRequest(contextPath.addSegment("versions"), Optional.empty());
    }

}
