package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DocumentComment;
import odata.msgraph.client.beta.entity.request.DocumentCommentReplyRequest;
import odata.msgraph.client.beta.entity.request.DocumentCommentRequest;

public class DocumentCommentCollectionRequest extends CollectionPageEntityRequest<DocumentComment, DocumentCommentRequest>{

    protected ContextPath contextPath;

    public DocumentCommentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DocumentComment.class, cp -> new DocumentCommentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DocumentCommentReplyRequest replies(String id) {
        return new DocumentCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DocumentCommentReplyCollectionRequest replies() {
        return new DocumentCommentReplyCollectionRequest(contextPath.addSegment("replies"), Optional.empty());
    }

}
