package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.DirectoryObject;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;

public class DirectoryObjectCollectionRequest extends CollectionPageEntityRequest<DirectoryObject, DirectoryObjectRequest>{

    protected ContextPath contextPath;

    public DirectoryObjectCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DirectoryObject.class, cp -> new DirectoryObjectRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "validateProperties")
    @JsonIgnore
    public ActionRequestNoReturn validateProperties(String entityType, String displayName, String mailNickname, UUID onBehalfOfUserId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("entityType", "Edm.String", Checks.checkIsAscii(entityType))
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("mailNickname", "Edm.String", Checks.checkIsAscii(mailNickname))
            .put("onBehalfOfUserId", "Edm.Guid", onBehalfOfUserId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateProperties"), _parameters);
    }

    @Action(name = "getByIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DirectoryObject> getByIds(List<String> ids, List<String> types) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .put("types", "Collection(Edm.String)", Checks.checkIsAscii(types))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getByIds"), DirectoryObject.class, _parameters);
    }

    @Action(name = "getUserOwnedObjects")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DirectoryObject> getUserOwnedObjects(String userId, String type) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("type", "Edm.String", Checks.checkIsAscii(type))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DirectoryObject>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserOwnedObjects"), DirectoryObject.class, _parameters);
    }

}
