package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementSettingCategory;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingCategoryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementSettingDefinitionRequest;

public class DeviceManagementSettingCategoryCollectionRequest extends CollectionPageEntityRequest<DeviceManagementSettingCategory, DeviceManagementSettingCategoryRequest>{

    protected ContextPath contextPath;

    public DeviceManagementSettingCategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementSettingCategory.class, cp -> new DeviceManagementSettingCategoryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(contextPath.addSegment("settingDefinitions"), Optional.empty());
    }

}
