package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.DeviceManagementScript;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptGroupAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptUserStateRequest;

public class DeviceManagementScriptCollectionRequest extends CollectionPageEntityRequest<DeviceManagementScript, DeviceManagementScriptRequest>{

    protected ContextPath contextPath;

    public DeviceManagementScriptCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementScript.class, cp -> new DeviceManagementScriptRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementScriptAssignmentRequest assignments(String id) {
        return new DeviceManagementScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptAssignmentCollectionRequest assignments() {
        return new DeviceManagementScriptAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

    public DeviceManagementScriptGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceManagementScriptGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceManagementScriptGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"), Optional.empty());
    }

    public DeviceManagementScriptUserStateRequest userRunStates(String id) {
        return new DeviceManagementScriptUserStateRequest(contextPath.addSegment("userRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptUserStateCollectionRequest userRunStates() {
        return new DeviceManagementScriptUserStateCollectionRequest(contextPath.addSegment("userRunStates"), Optional.empty());
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters);
    }

}
