package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementConfigurationPolicy;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationPolicyAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationPolicyRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementConfigurationSettingRequest;

public class DeviceManagementConfigurationPolicyCollectionRequest extends CollectionPageEntityRequest<DeviceManagementConfigurationPolicy, DeviceManagementConfigurationPolicyRequest>{

    protected ContextPath contextPath;

    public DeviceManagementConfigurationPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceManagementConfigurationPolicy.class, cp -> new DeviceManagementConfigurationPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceManagementConfigurationPolicyAssignmentRequest assignments(String id) {
        return new DeviceManagementConfigurationPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyAssignmentCollectionRequest assignments() {
        return new DeviceManagementConfigurationPolicyAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceManagementConfigurationSettingRequest settings(String id) {
        return new DeviceManagementConfigurationSettingRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingCollectionRequest settings() {
        return new DeviceManagementConfigurationSettingCollectionRequest(contextPath.addSegment("settings"), Optional.empty());
    }

}
