package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceConfigurationTargetedUserAndDevice;
import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.complex.IosAvailableUpdateVersion;
import odata.msgraph.client.beta.entity.DeviceConfiguration;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationDeviceStatusRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationGroupAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationUserStatusRequest;
import odata.msgraph.client.beta.entity.request.SettingStateDeviceSummaryRequest;

public class DeviceConfigurationCollectionRequest extends CollectionPageEntityRequest<DeviceConfiguration, DeviceConfigurationRequest>{

    protected ContextPath contextPath;

    public DeviceConfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceConfiguration.class, cp -> new DeviceConfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceConfigurationAssignmentRequest assignments(String id) {
        return new DeviceConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationAssignmentCollectionRequest assignments() {
        return new DeviceConfigurationAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public SettingStateDeviceSummaryRequest deviceSettingStateSummaries(String id) {
        return new SettingStateDeviceSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SettingStateDeviceSummaryCollectionRequest deviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(contextPath.addSegment("deviceSettingStateSummaries"), Optional.empty());
    }

    public DeviceConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new DeviceConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new DeviceConfigurationDeviceStatusCollectionRequest(contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public DeviceConfigurationGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceConfigurationGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceConfigurationGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"), Optional.empty());
    }

    public DeviceConfigurationUserStatusRequest userStatuses(String id) {
        return new DeviceConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationUserStatusCollectionRequest userStatuses() {
        return new DeviceConfigurationUserStatusCollectionRequest(contextPath.addSegment("userStatuses"), Optional.empty());
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters);
    }

    @Action(name = "getTargetedUsersAndDevices")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceConfigurationTargetedUserAndDevice> getTargetedUsersAndDevices(List<String> deviceConfigurationIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceConfigurationIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceConfigurationIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTargetedUsersAndDevices"), DeviceConfigurationTargetedUserAndDevice.class, _parameters);
    }

    @Function(name = "getIosAvailableUpdateVersions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<IosAvailableUpdateVersion> getIosAvailableUpdateVersions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getIosAvailableUpdateVersions"), IosAvailableUpdateVersion.class, _parameters);
    }

}
