package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceComplianceScript;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScriptDeviceStateRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceScriptRequest;
import odata.msgraph.client.beta.entity.request.DeviceHealthScriptAssignmentRequest;

public class DeviceComplianceScriptCollectionRequest extends CollectionPageEntityRequest<DeviceComplianceScript, DeviceComplianceScriptRequest>{

    protected ContextPath contextPath;

    public DeviceComplianceScriptCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceComplianceScript.class, cp -> new DeviceComplianceScriptRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceHealthScriptAssignmentRequest assignments(String id) {
        return new DeviceHealthScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceHealthScriptAssignmentCollectionRequest assignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceComplianceScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceComplianceScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceComplianceScriptDeviceStateCollectionRequest(contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

}
