package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignmentFilterState;
import odata.msgraph.client.beta.complex.AssignmentFilterSupportedProperty;
import odata.msgraph.client.beta.complex.AssignmentFilterValidationResult;
import odata.msgraph.client.beta.entity.DeviceAndAppManagementAssignmentFilter;
import odata.msgraph.client.beta.entity.request.DeviceAndAppManagementAssignmentFilterRequest;
import odata.msgraph.client.beta.enums.DevicePlatformType;

public class DeviceAndAppManagementAssignmentFilterCollectionRequest extends CollectionPageEntityRequest<DeviceAndAppManagementAssignmentFilter, DeviceAndAppManagementAssignmentFilterRequest>{

    protected ContextPath contextPath;

    public DeviceAndAppManagementAssignmentFilterCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DeviceAndAppManagementAssignmentFilter.class, cp -> new DeviceAndAppManagementAssignmentFilterRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "enable")
    @JsonIgnore
    public ActionRequestNoReturn enable(Boolean enable) {
        Preconditions.checkNotNull(enable, "enable cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enable", "Edm.Boolean", enable)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enable"), _parameters);
    }

    @Action(name = "validateFilter")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AssignmentFilterValidationResult> validateFilter(DeviceAndAppManagementAssignmentFilter deviceAndAppManagementAssignmentFilter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceAndAppManagementAssignmentFilter", "microsoft.graph.deviceAndAppManagementAssignmentFilter", deviceAndAppManagementAssignmentFilter)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AssignmentFilterValidationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateFilter"), AssignmentFilterValidationResult.class, _parameters);
    }

    @Function(name = "getPlatformSupportedProperties")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AssignmentFilterSupportedProperty> getPlatformSupportedProperties(DevicePlatformType platform) {
        Preconditions.checkNotNull(platform, "platform cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("platform", "microsoft.graph.devicePlatformType", platform)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPlatformSupportedProperties"), AssignmentFilterSupportedProperty.class, _parameters);
    }

    @Function(name = "getState")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<AssignmentFilterState> getState() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<AssignmentFilterState>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getState"), AssignmentFilterState.class, _parameters);
    }

}
