package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DelegatedAdminRelationship;
import odata.msgraph.client.beta.entity.request.DelegatedAdminAccessAssignmentRequest;
import odata.msgraph.client.beta.entity.request.DelegatedAdminRelationshipOperationRequest;
import odata.msgraph.client.beta.entity.request.DelegatedAdminRelationshipRequest;
import odata.msgraph.client.beta.entity.request.DelegatedAdminRelationshipRequestRequest;

public class DelegatedAdminRelationshipCollectionRequest extends CollectionPageEntityRequest<DelegatedAdminRelationship, DelegatedAdminRelationshipRequest>{

    protected ContextPath contextPath;

    public DelegatedAdminRelationshipCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DelegatedAdminRelationship.class, cp -> new DelegatedAdminRelationshipRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DelegatedAdminAccessAssignmentRequest accessAssignments(String id) {
        return new DelegatedAdminAccessAssignmentRequest(contextPath.addSegment("accessAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminAccessAssignmentCollectionRequest accessAssignments() {
        return new DelegatedAdminAccessAssignmentCollectionRequest(contextPath.addSegment("accessAssignments"), Optional.empty());
    }

    public DelegatedAdminRelationshipOperationRequest operations(String id) {
        return new DelegatedAdminRelationshipOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminRelationshipOperationCollectionRequest operations() {
        return new DelegatedAdminRelationshipOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public DelegatedAdminRelationshipRequestRequest requests(String id) {
        return new DelegatedAdminRelationshipRequestRequest(contextPath.addSegment("requests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminRelationshipRequestCollectionRequest requests() {
        return new DelegatedAdminRelationshipRequestCollectionRequest(contextPath.addSegment("requests"), Optional.empty());
    }

}
