package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DefaultManagedAppProtection;
import odata.msgraph.client.beta.entity.request.DefaultManagedAppProtectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedMobileAppRequest;

public class DefaultManagedAppProtectionCollectionRequest extends CollectionPageEntityRequest<DefaultManagedAppProtection, DefaultManagedAppProtectionRequest>{

    protected ContextPath contextPath;

    public DefaultManagedAppProtectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DefaultManagedAppProtection.class, cp -> new DefaultManagedAppProtectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(contextPath.addSegment("apps"), Optional.empty());
    }

}
