package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DlpEvaluationInput;
import odata.msgraph.client.beta.complex.DlpNotification;
import odata.msgraph.client.beta.entity.DataLossPreventionPolicy;
import odata.msgraph.client.beta.entity.DlpEvaluatePoliciesJobResponse;
import odata.msgraph.client.beta.entity.request.DataLossPreventionPolicyRequest;

public class DataLossPreventionPolicyCollectionRequest extends CollectionPageEntityRequest<DataLossPreventionPolicy, DataLossPreventionPolicyRequest>{

    protected ContextPath contextPath;

    public DataLossPreventionPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, DataLossPreventionPolicy.class, cp -> new DataLossPreventionPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "evaluate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DlpEvaluatePoliciesJobResponse> evaluate(String target, DlpEvaluationInput evaluationInput, DlpNotification notificationInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("target", "Edm.String", Checks.checkIsAscii(target))
            .put("evaluationInput", "microsoft.graph.dlpEvaluationInput", evaluationInput)
            .put("notificationInfo", "microsoft.graph.dlpNotification", notificationInfo)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DlpEvaluatePoliciesJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluate"), DlpEvaluatePoliciesJobResponse.class, _parameters);
    }

}
