package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CustomerPaymentJournal;
import odata.msgraph.client.beta.entity.request.CustomerPaymentJournalRequest;
import odata.msgraph.client.beta.entity.request.CustomerPaymentRequest;

public class CustomerPaymentJournalCollectionRequest extends CollectionPageEntityRequest<CustomerPaymentJournal, CustomerPaymentJournalRequest>{

    protected ContextPath contextPath;

    public CustomerPaymentJournalCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CustomerPaymentJournal.class, cp -> new CustomerPaymentJournalRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CustomerPaymentRequest customerPayments(String id) {
        return new CustomerPaymentRequest(contextPath.addSegment("customerPayments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomerPaymentCollectionRequest customerPayments() {
        return new CustomerPaymentCollectionRequest(contextPath.addSegment("customerPayments"), Optional.empty());
    }

}
