package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CustomSecurityAttributeDefinition;
import odata.msgraph.client.beta.entity.request.AllowedValueRequest;
import odata.msgraph.client.beta.entity.request.CustomSecurityAttributeDefinitionRequest;

public class CustomSecurityAttributeDefinitionCollectionRequest extends CollectionPageEntityRequest<CustomSecurityAttributeDefinition, CustomSecurityAttributeDefinitionRequest>{

    protected ContextPath contextPath;

    public CustomSecurityAttributeDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CustomSecurityAttributeDefinition.class, cp -> new CustomSecurityAttributeDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AllowedValueRequest allowedValues(String id) {
        return new AllowedValueRequest(contextPath.addSegment("allowedValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AllowedValueCollectionRequest allowedValues() {
        return new AllowedValueCollectionRequest(contextPath.addSegment("allowedValues"), Optional.empty());
    }

}
