package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ActionResultPart;
import odata.msgraph.client.beta.entity.ConversationMember;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;

public class ConversationMemberCollectionRequest extends CollectionPageEntityRequest<ConversationMember, ConversationMemberRequest>{

    protected ContextPath contextPath;

    public ConversationMemberCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ConversationMember.class, cp -> new ConversationMemberRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "add")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ActionResultPart> add(List<ConversationMember> values) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("values", "Collection(microsoft.graph.conversationMember)", values)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), ActionResultPart.class, _parameters);
    }

}
