package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CloudPcProvisioningPolicy;
import odata.msgraph.client.beta.entity.request.CloudPcProvisioningPolicyAssignmentRequest;
import odata.msgraph.client.beta.entity.request.CloudPcProvisioningPolicyRequest;

public class CloudPcProvisioningPolicyCollectionRequest extends CollectionPageEntityRequest<CloudPcProvisioningPolicy, CloudPcProvisioningPolicyRequest>{

    protected ContextPath contextPath;

    public CloudPcProvisioningPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CloudPcProvisioningPolicy.class, cp -> new CloudPcProvisioningPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CloudPcProvisioningPolicyAssignmentRequest assignments(String id) {
        return new CloudPcProvisioningPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcProvisioningPolicyAssignmentCollectionRequest assignments() {
        return new CloudPcProvisioningPolicyAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
