package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcSourceDeviceImage;
import odata.msgraph.client.beta.entity.CloudPcDeviceImage;
import odata.msgraph.client.beta.entity.request.CloudPcDeviceImageRequest;

public class CloudPcDeviceImageCollectionRequest extends CollectionPageEntityRequest<CloudPcDeviceImage, CloudPcDeviceImageRequest>{

    protected ContextPath contextPath;

    public CloudPcDeviceImageCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CloudPcDeviceImage.class, cp -> new CloudPcDeviceImageRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "getSourceImages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CloudPcSourceDeviceImage> getSourceImages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSourceImages"), CloudPcSourceDeviceImage.class, _parameters);
    }

}
