package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CloudPcAuditEvent;
import odata.msgraph.client.beta.entity.request.CloudPcAuditEventRequest;

public class CloudPcAuditEventCollectionRequest extends CollectionPageEntityRequest<CloudPcAuditEvent, CloudPcAuditEventRequest>{

    protected ContextPath contextPath;

    public CloudPcAuditEventCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CloudPcAuditEvent.class, cp -> new CloudPcAuditEventRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "getAuditActivityTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getAuditActivityTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAuditActivityTypes"), String.class, _parameters);
    }

}
