package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Channel;
import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.request.ChannelRequest;
import odata.msgraph.client.beta.entity.request.ChatMessageRequest;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;
import odata.msgraph.client.beta.entity.request.TeamsTabRequest;

public class ChannelCollectionRequest extends CollectionPageEntityRequest<Channel, ChannelRequest>{

    protected ContextPath contextPath;

    public ChannelCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Channel.class, cp -> new ChannelRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(contextPath.addSegment("messages"), Optional.empty());
    }

    public TeamsTabRequest tabs(String id) {
        return new TeamsTabRequest(contextPath.addSegment("tabs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsTabCollectionRequest tabs() {
        return new TeamsTabCollectionRequest(contextPath.addSegment("tabs"), Optional.empty());
    }

    @Function(name = "allMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> allMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allMessages"), ChatMessage.class, _parameters);
    }

    @Function(name = "getAllMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> getAllMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAllMessages"), ChatMessage.class, _parameters);
    }

}
